/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.Log;
import org.jivesoftware.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VccCustomAuthProvider
implements AuthProvider {
    private String vccSessionUrl;
    private String userNameHash;
    private String vccCookieSession;

    public VccCustomAuthProvider() {
        String prop1 = "vccCustomAuthProvider.userNameHash";
        String prop2 = "vccCustomAuthProvider.vccSessionUrl";
        String prop3 = "vccCustomAuthProvider.vccCookieSession";
        JiveGlobals.migrateProperty((String)prop1);
        JiveGlobals.migrateProperty((String)prop2);
        JiveGlobals.migrateProperty((String)prop3);
        this.userNameHash = JiveGlobals.getProperty((String)prop1);
        this.vccSessionUrl = JiveGlobals.getProperty((String)prop2);
        this.vccCookieSession = JiveGlobals.getProperty((String)prop3);
        if (this.userNameHash == null) {
            Log.error((String)("System property " + prop1 + " is not set"));
        }
        if (this.vccSessionUrl == null) {
            Log.error((String)("System property " + prop2 + " is not set"));
        }
        if (this.vccSessionUrl == null) {
            Log.error((String)("System property " + prop3 + " is not set"));
        }
    }

    public void authenticate(String username, String password) throws UnauthorizedException {
        if (username == null || password == null) {
            throw new UnauthorizedException();
        }
        String[] result = password.split("--", 2);
        if (result.length == 2 && result[0].equals(this.userNameHash)) {
            password = result[1];
            username = this.cookieVccAuthenticate(password);
        } else {
            username = this.restfulVccAuthenticate(username, password);
        }
        if (username == null) {
            throw new UnauthorizedException();
        }
        VccCustomAuthProvider.createUser(username);
    }

    public void authenticate(String username, String token, String digest) throws UnauthorizedException {
        throw new UnsupportedOperationException();
    }

    public boolean isPlainSupported() {
        return true;
    }

    public boolean isDigestSupported() {
        return false;
    }

    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setPassword(String username, String password) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsPasswordRetrieval() {
        return false;
    }

    private static void createUser(String username) {
        UserManager userManager = UserManager.getInstance();
        try {
            userManager.getUser(username);
        }
        catch (UserNotFoundException unfe) {
            try {
                Log.debug((String)("VccCustomAuthProvider: Automatically creating new user account for " + username));
                UserManager.getUserProvider().createUser(username, StringUtils.randomString((int)8), null, null);
            }
            catch (UserAlreadyExistsException userAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    private String cookieVccAuthenticate(String cookie) {
        String username = null;
        URLConnection con = null;
        try {
            URL url = new URL(this.vccSessionUrl);
            con = url.openConnection();
        }
        catch (MalformedURLException e1) {
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (con != null) {
            String myCookie = this.vccCookieSession + "=" + cookie;
            con.setRequestProperty("Cookie", myCookie);
            String xml = this.getXmlFromOpenConnection(con);
            username = this.getLoginFromXmlSession(xml);
        }
        return username;
    }

    private String restfulVccAuthenticate(String username, String password) {
        String usernameAuthenticated = null;
        URLConnection con = null;
        try {
            URL url = new URL(this.vccSessionUrl);
            con = url.openConnection();
            if (con != null) {
                String profileAndPassword = username + ":" + password;
                Base64 base64 = new Base64();
                byte[] encoding = base64.encode(profileAndPassword.getBytes());
                String authorizationString = "Basic " + new String(encoding);
                con.addRequestProperty("authorization", authorizationString);
                String xml = this.getXmlFromOpenConnection(con);
                usernameAuthenticated = this.getLoginFromXmlSession(xml);
            }
        }
        catch (MalformedURLException e1) {
        }
        catch (IOException e1) {
            // empty catch block
        }
        return usernameAuthenticated;
    }

    private String getXmlFromOpenConnection(URLConnection con) {
        String xml = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("<?xml")) continue;
                xml = xml + line;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return xml;
    }

    private String getLoginFromXmlSession(String xml) {
        String username = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Node doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            doc = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (doc != null) {
            NodeList textLoginList;
            Node firstChild = doc.getFirstChild();
            Element el = (Element)firstChild;
            doc.getDocumentElement().normalize();
            String login = "";
            NodeList loginList = el.getElementsByTagName("login");
            Element loginElement = (Element)loginList.item(0);
            if (loginElement != null && (login = (textLoginList = loginElement.getChildNodes()).item(0).getNodeValue()) != null && login != "") {
                username = login;
            }
        }
        return username;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PasswordType {
        plain,
        md5,
        sha1;

    }
}

