/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.group.GroupProvider;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.Log;
import org.xmpp.packet.JID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VccCustomGroupProvider
implements GroupProvider {
    private String connectionString;
    private String groupCountSQL;
    private String descriptionSQL;
    private String allGroupsSQL;
    private String userGroupsSQL;
    private String loadMembersSQL;
    private String loadAdminsSQL;
    private boolean useConnectionProvider;
    private XMPPServer server = XMPPServer.getInstance();

    public VccCustomGroupProvider() {
        JiveGlobals.migrateProperty((String)"jdbcProvider.driver");
        JiveGlobals.migrateProperty((String)"jdbcProvider.connectionString");
        JiveGlobals.migrateProperty((String)"jdbcGroupProvider.groupCountSQL");
        JiveGlobals.migrateProperty((String)"jdbcGroupProvider.allGroupsSQL");
        JiveGlobals.migrateProperty((String)"jdbcGroupProvider.userGroupsSQL");
        JiveGlobals.migrateProperty((String)"jdbcGroupProvider.descriptionSQL");
        JiveGlobals.migrateProperty((String)"jdbcGroupProvider.loadMembersSQL");
        JiveGlobals.migrateProperty((String)"jdbcGroupProvider.loadAdminsSQL");
        this.useConnectionProvider = JiveGlobals.getBooleanProperty((String)"jdbcGroupProvider.useConnectionProvider");
        if (!this.useConnectionProvider) {
            String jdbcDriver = JiveGlobals.getProperty((String)"jdbcProvider.driver");
            try {
                Class.forName(jdbcDriver).newInstance();
            }
            catch (Exception e) {
                Log.error((String)("Unable to load JDBC driver: " + jdbcDriver), (Throwable)e);
                return;
            }
            this.connectionString = JiveGlobals.getProperty((String)"jdbcProvider.connectionString");
        }
        this.groupCountSQL = JiveGlobals.getProperty((String)"jdbcGroupProvider.groupCountSQL");
        this.allGroupsSQL = JiveGlobals.getProperty((String)"jdbcGroupProvider.allGroupsSQL");
        this.userGroupsSQL = JiveGlobals.getProperty((String)"jdbcGroupProvider.userGroupsSQL");
        this.descriptionSQL = JiveGlobals.getProperty((String)"jdbcGroupProvider.descriptionSQL");
        this.loadMembersSQL = JiveGlobals.getProperty((String)"jdbcGroupProvider.loadMembersSQL");
        this.loadAdminsSQL = JiveGlobals.getProperty((String)"jdbcGroupProvider.loadAdminsSQL");
    }

    public Group createGroup(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private Connection getConnection() throws SQLException {
        if (this.useConnectionProvider) {
            return DbConnectionManager.getConnection();
        }
        return DriverManager.getConnection(this.connectionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String name) throws GroupNotFoundException {
        String description = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.descriptionSQL);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new GroupNotFoundException("Group with name " + name + " not found.");
            }
            description = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                Log.error((Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        Collection<JID> members = this.getMembers(name, false);
        Collection<JID> administrators = this.getMembers(name, true);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("sharedRoster.showInRoster", "onlyGroup");
        properties.put("sharedRoster.displayName", name);
        properties.put("sharedRoster.groupList", "");
        return new Group(name, description, members, administrators, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<JID> getMembers(String groupName, boolean adminsOnly) {
        ArrayList<JID> members = new ArrayList<JID>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            if (adminsOnly) {
                if (this.loadAdminsSQL == null) {
                    ArrayList<JID> arrayList = members;
                    DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
                    return arrayList;
                }
                pstmt = con.prepareStatement(this.loadAdminsSQL);
            } else {
                pstmt = con.prepareStatement(this.loadMembersSQL);
            }
            pstmt.setString(1, groupName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String user = rs.getString(1);
                if (user == null) continue;
                JID userJID = user.contains("@") ? new JID(user) : this.server.createJID(user, null);
                members.add(userJID);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException e) {
            Log.error((Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
        }
        return members;
    }

    public void setName(String oldName, String newName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setDescription(String name, String description) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        int count;
        block4: {
            count = 0;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = this.getConnection();
                pstmt = con.prepareStatement(this.groupCountSQL);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    Log.error((Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
            }
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return count;
    }

    public Collection<String> getSharedGroupsNames() {
        return this.getGroupNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.allGroupsSQL);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                Log.error((Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getGroupNames(int start, int num) {
        ArrayList<String> groupNames = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = DbConnectionManager.createScrollablePreparedStatement((Connection)con, (String)this.allGroupsSQL);
            rs = pstmt.executeQuery();
            DbConnectionManager.scrollResultSet((ResultSet)rs, (int)start);
            for (int count = 0; rs.next() && count < num; ++count) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                Log.error((Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getGroupNames(JID user) {
        ArrayList<String> groupNames = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.userGroupsSQL);
            pstmt.setString(1, this.server.isLocal(user) ? user.getNode() : user.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                Log.error((Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, (Connection)con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return groupNames;
    }

    public void addMember(String groupName, JID user, boolean administrator) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void updateMember(String groupName, JID user, boolean administrator) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void deleteMember(String groupName, JID user) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    public Collection<String> search(String query) {
        return Collections.emptyList();
    }

    public Collection<String> search(String query, int startIndex, int numResults) {
        return Collections.emptyList();
    }

    public boolean isSearchSupported() {
        return false;
    }
}

