import com.appletvnc.server.VNCServer;

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class VNCJ extends Applet
    implements MouseListener, ActionListener
{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6714495452696938107L;
	
	
	public VNCJ()
    {
        title = "Java VNC Server";
        startText = "Start";
        stopText = "Stop";
        aliasText = "Port alias";
        portText = "Port";
        hostName = "foreman.dit.upm.es";
        addressText = "Client Address";
        okButton = new Button("OK");
        actionButton = new Button(startText);
        //msgArea = new TextArea();
        sPane = new ScrollPane();
        aliasLabel = new Label(aliasText, 2);
        portLabel = new Label(portText, 2);
        addressLabel = new Label(addressText, 2);
        aliasField = new TextField(8);
        portField = new TextField(4);
        addressField = new TextField(12);
        params = new HashMap();
        autoStart = false;
        reverseMode = true;
        port = 5900;
        address = "localhost";
        alias = "null";
        vnc = new VNCServer();
    }

    public void startGUI()
    {
       Runnable runnable = new Runnable() {
            public void run()
            {
            	if (alias == null || alias.equals("null") )
            		alias = null;
            	
                if(true)
                    vnc.start(address, alias, port);
                else
                    vnc.start(alias, port, hostName);
                actionButton.setLabel(stopText);
                actionButton.setEnabled(true);
            }

        };
        SwingUtilities.invokeLater(runnable);
    }

    public void stopGUI()
    {
        /*Runnable runnable = new Runnable() {

            public void run()
            {*/
                if(vnc != null)
                    vnc.close();
                actionButton.setLabel(startText);
                actionButton.setEnabled(true);
        /*    }

        };
        SwingUtilities.invokeLater(runnable);*/
    }

    public void init()
    {
        instance = this;
        try
        {
            InetAddress inetaddress = InetAddress.getLocalHost();
            hostName = inetaddress.getHostName();
        }
        catch(UnknownHostException unknownhostexception)
        {
            unknownhostexception.printStackTrace();
        }
        String s = null;

        s = getParameter("titleLabel");
        if(s != null && s.length() > 0)
            title = s;
        //Object obj = null;
        s = getParameter("mainBackground");
        if(s != null && s.length() > 0)
            try
            {
                Color color = null;
                color = new Color(Integer.parseInt(s.trim(), 16));
                setBackground(color);
            }
            catch(Exception exception)
            {
                exception.printStackTrace();
            }
        s = getParameter("mainForeground");
        if(s != null && s.length() > 0)
            try
            {
                Color color1 = null;
                color1 = new Color(Integer.parseInt(s.trim(), 16));
                setForeground(color1);
            }
            catch(Exception exception1)
            {
                exception1.printStackTrace();
            }
        s = getParameter("buttonBackground");
        if(s != null && s.length() > 0)
            try
            {
                Color color2 = null;
                color2 = new Color(Integer.parseInt(s.trim(), 16));
                actionButton.setBackground(color2);
            }
            catch(Exception exception2)
            {
                exception2.printStackTrace();
            }
        s = getParameter("buttonForeground");
        if(s != null && s.length() > 0)
            try
            {
                Color color3 = null;
                color3 = new Color(Integer.parseInt(s.trim(), 16));
                actionButton.setForeground(color3);
            }
            catch(Exception exception3)
            {
                exception3.printStackTrace();
            }
        s = getParameter("msgBackground");
        if(s != null && s.length() > 0)
            try
            {
                new Color(Integer.parseInt(s.trim(), 16));
            }
            catch(Exception exception4)
            {
                exception4.printStackTrace();
            }
        s = getParameter("msgForeground");
        if(s != null && s.length() > 0)
            try
            {
                new Color(Integer.parseInt(s.trim(), 16));
            }
            catch(Exception exception5)
            {
                exception5.printStackTrace();
            }
        s = getParameter("startLabel");
        if(s != null && s.length() > 0)
            startText = s;
        s = getParameter("stopLabel");
        if(s != null && s.length() > 0)
            stopText = s;
        s = getParameter("portLabel");
        if(s != null && s.length() > 0)
            portText = s;
        s = getParameter("passwordLabel");
        if(s != null && s.length() > 0)
            aliasText = s;
        s = getParameter("addressLabel");
        if(s != null && s.length() > 0)
            addressText = s;
        s = getParameter("address");
        if(s != null && s.length() > 0)
            address = s;
        s = getParameter("password");
        if(s != null && s.length() > 0)
            alias = s;
        if("true".equalsIgnoreCase(getParameter("clientMode")) || "true".equalsIgnoreCase(getParameter("reverseMode")))
            reverseMode = true;
        else
            reverseMode = false;
        String s1 = getParameter("port");
        if(s1 != null)
            try
            {
                port = Integer.parseInt(s1);
            }
            catch(Exception exception6) { }
        else
        if(reverseMode)
            port = 5500;
        if("true".equalsIgnoreCase(getParameter("autoStart")))
            autoStart = true;
        else
            autoStart = false;
    }

    public void start()
    {
        Object obj;
        for(obj = this; ((Container) (obj)).getParent() != null && !(obj instanceof Frame); obj = ((Container) (obj)).getParent());
        if(!(obj instanceof Frame))
            obj = null;
        BorderLayout borderlayout = new BorderLayout();
        setLayout(borderlayout);
        actionButton.addActionListener(this);
        tLabel = new Label(title);
        tLabel.addMouseListener(this);
        tLabel.setAlignment(1);
        add(tLabel, "North");
        GridBagLayout gridbaglayout = new GridBagLayout();
        gridbaglayout.rowWeights = (new double[] {
            0.20000000000000001D, 0.59999999999999998D, 0.10000000000000001D
        });
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        Panel panel = new Panel();
        panel.setLayout(gridbaglayout);
        if(reverseMode)
        {
            gridbagconstraints.insets = new Insets(0, 1, 2, 1);
            gridbagconstraints.fill = 1;
            gridbagconstraints.gridheight = 1;
            gridbagconstraints.gridwidth = 1;
            gridbagconstraints.weightx = 0.10000000000000001D;
            gridbagconstraints.anchor = 17;
            gridbaglayout.setConstraints(addressLabel, gridbagconstraints);
            addressLabel.setText(addressText);
            addressLabel.addMouseListener(this);
            panel.add(addressLabel);
            gridbagconstraints.gridwidth = 2;
            gridbagconstraints.weightx = 0.20000000000000001D;
            addressField.setText(address);
            panel.add(addressField);
        }
        gridbagconstraints.insets = new Insets(0, 1, 2, 1);
        gridbagconstraints.fill = 1;
        gridbagconstraints.gridheight = 1;
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.weightx = 0.10000000000000001D;
        gridbagconstraints.anchor = 17;
        gridbaglayout.setConstraints(portLabel, gridbagconstraints);
        portLabel.setText(portText);
        portLabel.addMouseListener(this);
        panel.add(portLabel);
        gridbagconstraints.gridwidth = 2;
        gridbagconstraints.weightx = 0.20000000000000001D;
        portField.setText("" + port);
        panel.add(portField);
        if(!reverseMode)
        {
            gridbagconstraints.insets = new Insets(0, 1, 2, 1);
            gridbagconstraints.fill = 1;
            gridbagconstraints.gridheight = 1;
            gridbagconstraints.gridwidth = 1;
            gridbagconstraints.weightx = 0.10000000000000001D;
            gridbagconstraints.anchor = 17;
            gridbaglayout.setConstraints(aliasLabel, gridbagconstraints);
            aliasLabel.setText(aliasText);
            aliasLabel.addMouseListener(this);
            panel.add(aliasLabel);
            gridbagconstraints.gridwidth = 2;
            gridbagconstraints.weightx = 0.20000000000000001D;
            aliasField.setText(alias);
            panel.add(aliasField);
        }
        gridbagconstraints.fill = 1;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.gridheight = 1;
        gridbaglayout.setConstraints(actionButton, gridbagconstraints);
        actionButton.setLabel(startText);
        panel.add(actionButton);
        add(panel, "Center");
        add(new Label(" "), "East");
        add(new Label(" "), "South");
        add(new Label(" "), "West");
        setSize(500,500);
        validate();
        setVisible(true);
        if(autoStart)
        {
            actionButton.setEnabled(false);
            startGUI();
        }
    }

    public void actionPerformed(ActionEvent actionevent)
    {
        Object obj = actionevent.getSource();
        if(obj == actionButton)
        {
            if(startText.equals(actionButton.getLabel()))
            {
                if(reverseMode)
                {
                    String s = addressField.getText();
                    if(s != null && s.trim().length() > 0)
                        address = s.trim();
                } else
                {
                    alias = aliasField.getText();
                    if(alias != null && alias.trim().length() == 0)
                        alias = null;
                }
                try
                {
                    port = Integer.parseInt(portField.getText());
                }
                catch(Exception exception) { }
                startGUI();
            } else
            if(stopText.equals(actionButton.getLabel()))
                stopGUI();
        }
    }

    public void destroy()
    {
        super.destroy();
        if(vnc != null)
            vnc.close();
    }

    public void mouseClicked(MouseEvent mouseevent)
    {
        /*Dimension dimension = getToolkit().getScreenSize();
        Dimension dimension1 = about.getSize();
        int i = (dimension.width - dimension1.width) / 2;
        int j = (dimension.height - dimension1.height) / 2;
        about.setLocation(i, j);
        about.setVisible(true);*/
    }

    public void mouseEntered(MouseEvent mouseevent)
    {
    }

    public void mouseExited(MouseEvent mouseevent)
    {
    }

    public void mousePressed(MouseEvent mouseevent)
    {
    }

    public void mouseReleased(MouseEvent mouseevent)
    {
    }

    public static VNCJ instance = null;
    public String title;
    public String startText;
    public String stopText;
    public String aliasText;
    public String portText;
    public String hostName;
    public String addressText;
    public Button okButton;
    public Button actionButton;
    public ScrollPane sPane;
    public Label tLabel;
    public Label aliasLabel;
    public Label portLabel;
    public Label addressLabel;
    public TextField aliasField;
    public TextField portField;
    public TextField addressField;
    public Map params;
    public boolean autoStart;
    public boolean reverseMode;
    public int port;
    public String address;
    public String alias;
    public VNCServer vnc;

   public static void main(String [] args) {
    	
    }

}