package com.appletvnc.client;

import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class RobotClient
{

    public RobotClient()
    {
        index = 0;
        rects = new Rectangle[16];
        for(int i = 0; i < 4; i++)
        {
            for(int j = 0; j < 4; j++)
                rects[i * 4 + j] = new Rectangle();

        }

    }

    protected Rect[] getChangedImages(BufferedImage bufferedimage)
    {
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        if(oldImage == null || oldImage.getWidth() != i || oldImage.getHeight() != j)
        {
            index = 0;
            int k = i / 4;
            int l = j / 4;
            for(int j1 = 0; j1 < 4; j1++)
            {
                for(int k1 = 0; k1 < 4; k1++)
                {
                    rects[j1 * 4 + k1].x = k * j1;
                    rects[j1 * 4 + k1].y = l * k1;
                    rects[j1 * 4 + k1].width = k;
                    rects[j1 * 4 + k1].height = l;
                }

            }

            Rect rect = Rect.encode(pe, pf, bufferedimage, 0, 0);
            oldImage = bufferedimage;
            return (new Rect[] {
                rect
            });
        }
        ArrayList<Object> arraylist = new ArrayList<Object>();
        for(int i1 = 0; i1 < 16; i1++)
        {
            Rect rect1 = getChangedImages(bufferedimage, i1);
            if(rect1 != null)
                arraylist.add(rect1);
        }

        oldImage = bufferedimage;
        if(arraylist.size() > 0)
        {
            Rect arect[] = new Rect[0];
            arect = (Rect[])arraylist.toArray(arect);
            return arect;
        } else
        {
            return null;
        }
    }

    private Rect getChangedImages(BufferedImage bufferedimage, int i)
    {
        int j;
        int l;
        int i1;
        int j1;
        int k1;
        int l1;
        Rectangle rectangle = rects[i];
        j = 0;
        l = 0;
        i1 = rectangle.x;
        j1 = rectangle.y;
        k1 = rectangle.x + rectangle.width;
        l1 = rectangle.y + rectangle.height;
        try {
        for(j = i1; j < k1; j++)
            for(l = j1; l < l1; l++)
                if(oldImage.getRGB(j, l) != bufferedimage.getRGB(j, l))
                    throw new Exception();


        return null;
        } catch(Exception exception) {}
        i1 = j;
        try {
        for(l = j1; l < l1; l++)
            for(j = i1; j < k1; j++)
                if(oldImage.getRGB(j, l) != bufferedimage.getRGB(j, l))
                    throw new Exception();


        return null;
        } catch(Exception exception) {}
        j1 = l;
        try {
        for(j = k1 - 1; j > i1; j--)
            for(l = j1; l < l1; l++)
                if(oldImage.getRGB(j, l) != bufferedimage.getRGB(j, l))
                    throw new Exception();


        return null;
        } catch(Exception exception) {}
        k1 = j;
        try {
        for(l = l1 - 1; l > j1; l--)
        {
            for(int k = k1; k > i1; k--)
                if(oldImage.getRGB(k, l) != bufferedimage.getRGB(k, l))
                    throw new Exception();

        }

        return null;
        } catch(Exception exception) {}
        l1 = l;
        if(k1 - i1 <= 0 || l1 - j1 <= 0)
            return null;
        int i2 = i1 % 16;
        if(i2 != 0)
            i1 -= i2;
        i2 = j1 % 16;
        if(i2 != 0)
            j1 -= i2;
        i2 = k1 % 16;
        if(i2 != 0)
            k1 = (k1 - i2) + 16;
        i2 = l1 % 16;
        if(i2 != 0)
            l1 = (l1 - i2) + 16;
        Rect rect;
        System.out.println("" + i1 + ":" + j1 + ":" + k1 + ":" + l1 + ":" + (k1 - i1) + ":" + (l1 - j1));
        try {
        	rect = Rect.encode(pe, pf, bufferedimage.getSubimage(i1, j1, k1 - i1, l1 - j1), i1, j1);
        	return rect;
        } catch (Exception exception1) {
        	exception1.printStackTrace();
        	return null;
    	}
    }

    public static final int CELLS = 4;
    protected int pe;
    protected PixelFormat pf;
    protected int no;
    protected Colour colourMap[];
    protected BufferedImage oldImage;
    protected int index;
    protected Rectangle rects[];
}