package com.appletvnc.client;

import gnu.rfb.Colour;
import gnu.rfb.KeyCode;
import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import gnu.rfb.keysym;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBServer;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VNCRobot extends Component
    implements RFBServer, Runnable
{

    /**
	 * 
	 */
	private static final long serialVersionUID = 698598542718697299L;

	public VNCRobot(int i, String s)
    {
        shift = false;
        rects = new Rectangle[16];
        oldImages = new BufferedImage[16];
        rectRatos = new int[16];
        clients = new HashMap<Object, Object>();
        defaultPixel = null;
        times = 0;
        mouseModifiers = 0;
        displayName = s;
        device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        try
        {
            robot = new Robot();
            (new Thread(this)).start();
        }
        catch(AWTException awtexception)
        {
            awtexception.printStackTrace();
        }
    }

    public void addClient(RFBClient rfbclient)
    {
        if(!clients.containsKey(rfbclient))
        {
            RobotClient robotclient = new RobotClient();
            robotclient.no = clientNo++;
            clients.put(rfbclient, robotclient);
        }
    }

    public void removeClient(RFBClient rfbclient)
    {
        if(rfbclient != null && clients.containsKey(rfbclient))
        {
            System.out.println("Closed client:" + rfbclient);
            clients.remove(rfbclient);
            try
            {
                rfbclient.close();
            }
            catch(Exception exception) { }
        }
    }

    public String getDesktopName(RFBClient rfbclient)
    {
        RobotClient robotclient = (RobotClient)clients.get(rfbclient);
        if(robotclient == null)
        {
            addClient(rfbclient);
            robotclient = (RobotClient)clients.get(rfbclient);
        }
        return displayName + "_" + robotclient.no;
    }

    public int getFrameBufferWidth(RFBClient rfbclient)
    {
        return device.getDefaultConfiguration().getBounds().width;
    }

    public int getFrameBufferHeight(RFBClient rfbclient)
    {
        return device.getDefaultConfiguration().getBounds().height;
    }

    public PixelFormat getPreferredPixelFormat(RFBClient rfbclient)
    {
        return PixelFormat.RGB888;
    }

    public boolean allowShared()
    {
        return true;
    }

    public void setClientProtocolVersionMsg(RFBClient rfbclient, String s)
        throws IOException
    {
        System.out.println("version " + s);
    }

    public void setShared(RFBClient rfbclient, boolean flag)
        throws IOException
    {
        System.out.println("share " + flag);
    }

    public void setPixelFormat(RFBClient rfbclient, PixelFormat pixelformat)
        throws IOException
    {
        if(pixelformat != null)
            defaultPixel = pixelformat;
        pixelformat.setColorModel(Toolkit.getDefaultToolkit().getColorModel());
        System.out.println("pixelFormat");
        pixelformat.print(System.out);
    }

    public void setEncodings(RFBClient rfbclient, int ai[])
        throws IOException
    {
        System.out.print("encodings");
        for(int i = 0; i < ai.length; i++)
        {
            System.out.print(ai[i]);
            System.out.print(",");
        }

        System.out.println();
    }

    public void fixColourMapEntries(RFBClient rfbclient, int i, Colour acolour[])
        throws IOException
    {
        RobotClient robotclient = (RobotClient)clients.get(rfbclient);
        if(robotclient == null)
        {
            addClient(rfbclient);
            robotclient = (RobotClient)clients.get(rfbclient);
        }
        robotclient.colourMap = acolour;
        System.out.println("fixColourMapEntries");
    }

    public void frameBufferUpdateRequest(RFBClient rfbclient, boolean flag, int i, int j, int k, int l)
        throws IOException
    {
        int i1 = getFrameBufferWidth(rfbclient);
        int j1 = getFrameBufferHeight(rfbclient);
        if(i < 0 || j < 0 || k <= 0 || l <= 0)
        {
            System.out.println("Neg:" + i + ":" + j + ":" + k + ":" + l);
            return;
        }
        if(i + k > i1)
        {
            System.out.println("Too wide");
            return;
        }
        if(j + l > j1)
        {
            System.out.println("Too high");
            return;
        }
        PixelFormat pixelformat = rfbclient.getPixelFormat();
        if(pixelformat == null)
            pixelformat = defaultPixel;
        if(pixelformat == null)
            return;
        Rect arect[] = null;
        try
        {
            BufferedImage bufferedimage = robot.createScreenCapture(new Rectangle(i, j, k, l));
            //encode (encoding, pixelformat, Buffered Image, x, y , w, h)
            Rect rect = Rect.encode(rfbclient.getPreferredEncoding(), pixelformat, bufferedimage, i, j, k, l);
            arect = (new Rect[] {
                rect
            });
            System.out.println("Client Update:" + i + ":" + j + ":" + k + ":" + l);
            times = -1;
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
        }
        if(arect != null)
            rfbclient.writeFrameBufferUpdate(arect);
    }

    public void keyEvent(RFBClient rfbclient, boolean flag, int i)
        throws IOException
    {
        KeyCode keycode = keysym.toVKCode(i);
        if(keycode != null)
        {
            try
            {
                if(flag)
                {
                    if(!keycode.isShift);
                    robot.keyPress(keycode.key);
                    if(keycode.key == 16)
                        shift = true;
                } else
                {
                    robot.keyRelease(keycode.key);
                    if(keycode.key == 16)
                        shift = false;
                    if(!keycode.isShift);
                }
            }
            catch(Exception exception)
            {
                System.out.println(exception.getMessage());
            }
        }
        /*if(!isWindows || flag)
        	return;
        if(shift)
            robot.keyRelease(16);
        robot.keyPress(18);
        String s = String.valueOf(i);
        for(int j = 0; j < s.length(); j++)
        {
            String s1 = s.substring(j, j + 1);
            int k = Integer.parseInt(s1);
            robot.keyPress(96 + k);
            robot.keyRelease(96 + k);
        }

        robot.keyRelease(18);
        try
        {
            robot.keyRelease(18);
        }
        catch(Exception exception1)
        {
            exception1.printStackTrace();
        }
        try
        {
            robot.keyRelease(18);
        }
        catch(Exception exception3)
        {
            exception3.printStackTrace();
        }

        try
        {
            robot.keyRelease(18);
        }
        catch(Exception exception5)
        {
            exception5.printStackTrace();
        }*/

    }

    public void pointerEvent(RFBClient rfbclient, int i, int j, int k)
        throws IOException
    {
        int l = 0;
        if((i & 1) != 0)
            l |= 0x10;
        if((i & 2) != 0)
            l |= 8;
        if((i & 4) != 0)
            l |= 4;
        try
        {
            if(l != mouseModifiers)
            {
                if(mouseModifiers == 0)
                {
                    robot.mouseMove(j, k);
                    robot.mousePress(l);
                } else
                {
                    robot.mouseRelease(mouseModifiers);
                }
                mouseModifiers = l;
            } else
            {
                robot.mouseMove(j, k);
            }
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
        }
    }

    public void clientCutText(RFBClient rfbclient, String s)
        throws IOException
    {
    }

    public boolean isUpdateAvailable(RFBClient rfbclient)
    {
        return false;
    }

    private Rectangle alignRectangle(Rectangle rectangle)
    {
        int i = rectangle.x % 16;
        if(i != 0)
            rectangle.x = rectangle.x - i;
        i = rectangle.y % 16;
        if(i != 0)
            rectangle.y = rectangle.y - i;
        i = rectangle.width % 16;
        if(i != 0)
        {
            rectangle.width = (rectangle.width - i) + 16;
            if(rectangle.x + rectangle.width > dw)
                rectangle.width = dw - rectangle.x;
        }
        i = rectangle.height % 16;
        if(i != 0)
        {
            rectangle.height = (rectangle.height - i) + 16;
            if(rectangle.y + rectangle.height > dh)
                rectangle.height = dh - rectangle.y;
        }
        return rectangle;
    }

    private Rectangle getChangeArea(BufferedImage bufferedimage, BufferedImage bufferedimage1, Rectangle rectangle)
    {
        int i;
        int k;
        i = 0;
        k = 0;
        //boolean flag = false;
        //boolean flag1 = false;
        //int j1 = rectangle.width;
        //int l1 = rectangle.height;
        try {
        for(i = 0; i < rectangle.width; i++)
            for(k = 0; k < rectangle.height; k++)
                if(bufferedimage.getRGB(i, k) != bufferedimage1.getRGB(i, k))
                    throw new Exception();
        return null;
        } catch(Exception exception) {}
        int l = i;
        try {
        for(k = 0; k < rectangle.height; k++)
            for(i = l; i < rectangle.width; i++)
                if(bufferedimage.getRGB(i, k) != bufferedimage1.getRGB(i, k))
                    throw new Exception();


        return null;
    	} catch(Exception exception) {}
        int i1 = k;
        try {
        for(i = rectangle.width; i > l; i--)
            for(k = i1; k < rectangle.height; k++)
                if(bufferedimage.getRGB(i, k) != bufferedimage1.getRGB(i, k))
                    throw new Exception();


        return null;
        } catch(Exception exception) {}
        int k1 = i;
        try {
        for(k = rectangle.height; k > i1; k--)
        {
            for(int j = k1; j > l; j--)
                if(bufferedimage.getRGB(j, k) != bufferedimage1.getRGB(j, k))
                    throw new Exception();

        }

        return null;
        } catch(Exception exception) {}
        int i2 = k;
        if(k1 - l > 0 && i2 - i1 > 0)
            return new Rectangle(l, i1, k1 - l, i2 - i1);
        else
            return null;
    }

    public void run()
    {
        dw = device.getDefaultConfiguration().getBounds().width;
        dh = device.getDefaultConfiguration().getBounds().height;
        int i = dw / 4;
        int j = dh / 4;
        BufferedImage bufferedimage = robot.createScreenCapture(new Rectangle(0, 0, dw, dh));
        for(int k = 0; k < 4; k++)
        {
            for(int l = 0; l < 4; l++)
            {
                Rectangle rectangle = new Rectangle();
                rectangle.x = i * k;
                rectangle.y = j * l;
                rectangle.width = i;
                rectangle.height = j;
                rectangle = alignRectangle(rectangle);
                rects[k * 4 + l] = rectangle;
                oldImages[k * 4 + l] = bufferedimage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }

        }

        ArrayList<Object> arraylist = new ArrayList<Object>();
        int i1 = 0;
        //Object obj = null;
        try
        {
            Thread.sleep(300L);
        }
        catch(Exception exception) { }
        long l1 = System.currentTimeMillis();
        do
        {
            if(stop)
                break;
            if(defaultPixel == null)
                try
                {
                    Thread.sleep(1000L);
                }
                catch(Exception exception1) { }
            else
            if(times++ > 0)
                try
                {
                    if(clients.size() > 0)
                    {
                        int j1 = 0;
                        Rectangle rectangle1 = null;
                        do
                        {
                            if(rectRatos[i1] >= 0)
                            {
                                Rectangle rectangle2 = rects[i1];
                                //long l2 = System.currentTimeMillis();
                                BufferedImage bufferedimage1 = robot.createScreenCapture(rectangle2);
                                //l2 = System.currentTimeMillis();
                                rectangle1 = getChangeArea(oldImages[i1], bufferedimage1, rectangle2);
                                if(rectangle1 != null)
                                {
                                    Iterator iterator = clients.keySet().iterator();
                                    do
                                    {
                                        if(!iterator.hasNext())
                                            break;
                                        RFBClient rfbclient = (RFBClient)iterator.next();
                                        RobotClient robotclient = (RobotClient)clients.get(rfbclient);
                                        robotclient.pe = rfbclient.getPreferredEncoding();
                                        robotclient.pf = rfbclient.getPixelFormat();
                                        if(robotclient.pf == null)
                                            robotclient.pf = defaultPixel;
                                        Rect rect = Rect.encode(robotclient.pe, robotclient.pf, bufferedimage1.getSubimage(rectangle1.x, rectangle1.y, rectangle1.width, rectangle1.height), rectangle1.x + rectangle2.x, rectangle1.y + rectangle2.y);
                                        Rect arect[] = {
                                            rect
                                        };
                                        if(arect != null)
                                            try
                                            {
                                                rfbclient.writeFrameBufferUpdate(arect);
                                            }
                                            catch(SocketException socketexception)
                                            {
                                                arraylist.add(rfbclient);
                                            }
                                            catch(Exception exception8)
                                            {
                                                exception8.printStackTrace();
                                            }
                                    } while(true);
                                    for(int k1 = 0; k1 < arraylist.size(); k1++)
                                    {
                                        RFBClient rfbclient1 = (RFBClient)arraylist.get(k1);
                                        removeClient(rfbclient1);
                                    }

                                    arraylist.clear();
                                    try
                                    {
                                        Thread.sleep(5L);
                                    }
                                    catch(Exception exception7) { }
                                    j1 += 5;
                                    oldImages[i1] = bufferedimage1;
                                    rectRatos[i1]++;
                                } else
                                {
                                    try
                                    {
                                        Thread.sleep(10L);
                                    }
                                    catch(Exception exception6) { }
                                    rectRatos[i1]--;
                                }
                            }
                            i1 = (i1 + 1) % 16;
                            if(i1 == 0)
                            {
                                if(System.currentTimeMillis() - l1 > 3000L)
                                {
                                    l1 = System.currentTimeMillis();
                                    Arrays.fill(rectRatos, 0);
                                }
                                if(j1 == 0)
                                    try
                                    {
                                        Thread.sleep(500L);
                                    }
                                    catch(Exception exception5) { }
                            }
                        } while(rectangle1 == null && i1 != 0);
                    } else
                    {
                        try
                        {
                            Thread.sleep(1000L);
                        }
                        catch(Exception exception2) { }
                    }
                }
                catch(Exception exception3)
                {
                    exception3.printStackTrace();
                }
                finally
                {
                    //throw exception9;
                }
            else
                try
                {
                    Thread.sleep(2000L);
                }
                catch(Exception exception4) { }
        } while(true);
    }

    public void close()
    {
        System.out.println("Close robot");
        stop = true;
    }

    static String OS;
    static boolean isWindows;
    boolean shift;
    static final int CELLS = 4;
    Rectangle rects[];
    BufferedImage oldImages[];
    int rectRatos[];
    static int clientNo = 0;
    Map<Object, Object> clients;
    private PixelFormat defaultPixel;
    private int times;
    private String displayName;
    private GraphicsDevice device;
    private Robot robot;
    private int mouseModifiers;
    private boolean stop;
    int dw;
    int dh;

    static
    {
        OS = System.getProperty("os.name").toLowerCase();
        isWindows = OS.indexOf("windows") >= 0 || OS.indexOf("NT") >= 0;
    }
}