package com.appletvnc.server;

import gnu.rfb.server.*;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.*;
import java.util.ArrayList;

import org.http.client.HTTPTSocket;

public class VNCHost
    implements Runnable
{

    private String alias;
	public VNCHost(int i, String s, Class<?> class1, RFBAuthenticator rfbauthenticator, boolean flag, String alias)
        throws NoSuchMethodException
    {
        sharedServer = null;
        servers = new ArrayList<Object>();
        reverseMode = false;
        reverseMode = flag;
        constructor = class1.getDeclaredConstructor(new Class[] {
            Integer.TYPE, java.lang.String.class
        });
        if(!(gnu.rfb.server.RFBServer.class).isAssignableFrom(class1))
        {
            throw new NoSuchMethodException("Class does not support RFBServer interface");
        } else
        {
            display = i;
            displayName = s;
            authenticator = rfbauthenticator;
            this.alias = alias;
            (new Thread(this)).start();
            return;
        }
    }

    public synchronized void setSharedServer(RFBServer rfbserver)
    {
        sharedServer = rfbserver;
    }

    public synchronized RFBServer getSharedServer()
    {
        return sharedServer;
    }

    private void openServer()
    {
        try
        {
            serverSocket = new ServerSocket(5900 + display);
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            close();
            return;
        }
        try
        {
            setSharedServer((RFBServer)constructor.newInstance(new Object[] {
                new Integer(display), displayName
            }));
            while(isRunning)
            {
                Socket socket = serverSocket.accept();
                if(servers.size() == 0)
                {
                	InetAddress inetaddress = socket.getInetAddress();
                //VLogger.getLogger().log("MSG7", inetaddress.getHostAddress() + " - " + inetaddress.getCanonicalHostName());
                RFBSocket rfbsocket = new RFBSocket(socket, getSharedServer(), this, authenticator);
                servers.add(rfbsocket);
                } else
                {
                    try
                    {
                        socket.close();
                    }
                    catch(Exception exception2) { }
                }
            }
        }
        catch(Exception exception1)
        {
        }
        finally
        {
            threadFinished = true;
            close();
        }
    }

    private void addClientSocket()
    {
        try
        {
            try
            {
            	if (alias != null) {
            		System.out.println("Por HTTPTSocket: " + alias);
            		HTTPTSocket socket = new HTTPTSocket();
            		socket.connect(new InetSocketAddress(displayName, 5500 + display),alias);
            		socket.isConnected();
            		if(servers.size() == 0)
            		{
            			setSharedServer((RFBServer)constructor.newInstance(new Object[] {
            					new Integer(display), displayName
            			}));
            			//InetAddress inetaddress = socket.getInetAddress();
            			RFBSocket rfbsocket = new RFBSocket(socket, getSharedServer(), this, authenticator);
            			servers.add(rfbsocket);
            		} else
            		{
            			try
            			{
            				socket.close();
            			}
            			catch(Exception exception1) { }
            		}
            		while(isRunning && socket.isConnected())
            			try
            		{
            				Thread.sleep(2000L);
            		}
            		catch(Exception exception2) { }
            		System.out.println("Stopped Client mode at " + displayName);
            		try
            		{
            			socket.close();
            		}
            		catch(Exception exception3) { }
            	} else {
            		Socket socket = new Socket();
            		System.out.println("Por Socket: " + alias);
            		socket.connect(new InetSocketAddress(displayName, 5500 + display));
            		socket.isConnected();
            		if(servers.size() == 0)
            		{
            			setSharedServer((RFBServer)constructor.newInstance(new Object[] {
            					new Integer(display), displayName
            			}));
            			//InetAddress inetaddress = socket.getInetAddress();
            			RFBSocket rfbsocket = new RFBSocket(socket, getSharedServer(), this, authenticator);
            			servers.add(rfbsocket);
            		} else
            		{
            			try
            			{
            				socket.close();
            			}
            			catch(Exception exception1) { }
            		}
            		while(isRunning && socket.isConnected())
            			try
            		{
            				Thread.sleep(2000L);
            		}
            		catch(Exception exception2) { }
            		System.out.println("Stopped Client mode at " + displayName);
            		try
            		{
            			socket.close();
            		}
            		catch(Exception exception3) { }
            	}
            }
            catch(UnknownHostException unknownhostexception)
            {
            }
            catch(IOException ioexception)
            {
            }
            catch(SecurityException securityexception)
            {
            }
            catch(Exception exception)
            {
            }
        }
        finally
        {
        	System.out.println("terminado del todo");
            threadFinished = true;
            close();
        }
    }

    public void run()
    {
        isRunning = true;
        threadFinished = false;
        System.out.println(reverseMode);
        if(reverseMode)
            addClientSocket();
        else
            openServer();
    }

    public void close(RFBSocket rfbsocket)
    {
        try
        {
            System.out.println("Close:" + rfbsocket);
            servers.remove(rfbsocket);
            System.out.println("Removed?:" + servers.size());
        }
        catch(Exception exception) { }
    }

    public void close()
    {
        if(!isRunning)
            return;
        isRunning = false;
        try
        {
            serverSocket.close();
        }
        catch(Exception exception) { }
        serverSocket = null;
        while(!threadFinished)
            try
            {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch(InterruptedException interruptedexception) { }
        while(servers.size() > 0)
        {
            RFBSocket rfbsocket = (RFBSocket)servers.get(0);
            rfbsocket.close();
            try
            {
                servers.remove(rfbsocket);
            }
            catch(Exception exception2) { }
        }
        try {
        	if(sharedServer != null)
        		sharedServer.close();
        	serverSocket = null;
        } catch(Exception exception1) {
        	exception1.printStackTrace();
        	serverSocket = null;
        }
    }

    public String getDisplayName()
    {
        return displayName;
    }

    private int display;
    private String displayName;
    private RFBAuthenticator authenticator;
    private Constructor constructor;
    private RFBServer sharedServer;
    private boolean isRunning;
    private boolean threadFinished;
    private ServerSocket serverSocket;
    private ArrayList<Object> servers;
    private boolean reverseMode;
}