package gnu.rfb;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PackedColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.*;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.text.html.HTMLDocument.Iterator;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;

public class Tight extends Rect
{
    public static class SubRect
    {

        public int pixel;
        public int x;
        public int y;
        public int w;
        public int h;

        public SubRect()
        {
        }
    }

    public static class Tile
    {

        public int bgpixel;
        public SubRect subrects[];

        public Tile()
        {
        }
    }
    
    public PixelFormat pixelFormat;
    public Object tiles[];
    private byte[] imagen;
    private BufferedImage bufimg;
    private int veces = 0;
    
    public Tight(int ai[], PixelFormat pixelformat, int i, int j, int k, int l, int i1, 
            int j1, int k1)
    {
        super(l, i1, j1, k1);
        
        pixelFormat = pixelformat;
        
        MemoryImageSource memi = new MemoryImageSource(j1, k1,ai,0,j1);
        Image imagenTemp = Toolkit.getDefaultToolkit().createImage(memi);
        try{
      
        BufferedImage imagenTotal = new BufferedImage(j1,k1,BufferedImage.TYPE_INT_RGB);
       
        Graphics g = imagenTotal.getGraphics();
        g.drawImage(imagenTemp, 0,0,null);
        
        g.dispose();    
        
        FileOutputStream pepe = null; 
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        
        try{
        	java.util.Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        	ImageWriter writer = iter.next();
        	ImageWriteParam iwp = writer.getDefaultWriteParam();
        	iwp.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
        	iwp.setCompressionQuality(0.6f);   // an integer between 0 and 1
        	// 1 specifies minimum compression and maximum quality
        	MemoryCacheImageOutputStream output = new MemoryCacheImageOutputStream(out);
        	writer.setOutput(output);
        	IIOImage image = new IIOImage(imagenTotal, null, null);
        	writer.write(null, image, iwp);
        	//ImageIO.write(imagenTotal, "jpeg", out);
            imagen = out.toByteArray();
            

        }catch (Exception e){
        	e.printStackTrace();
        }
        }catch(Exception e){
        	
        }  
    }

    public Tight(int i, int j, int k, int l, PixelFormat pixelformat, byte aobj[])
    {
        super(i, j, k, l);
        pixelFormat = pixelformat;
        imagen = aobj;
    }
   
    private boolean first = true;

    public void writeData(DataOutput dataoutput)
        throws IOException
    {
        super.writeData(dataoutput);
        dataoutput.writeInt(7); // Encoding Tight
        dataoutput.writeByte(0x90); // Jpeg
        dataoutput.write(this.getCompactLen(imagen.length));
        /*if (first && imagen.length > 100) {
        	for (int i = 100; i>0;i--) System.out.println(imagen[imagen.length - i]);
        	first = false;
        }*/
        dataoutput.write(imagen);
     }

    public Object clone()
        throws CloneNotSupportedException
    {
        return new Tight(x, y, w, h, pixelFormat, imagen);
    }
   	
	private byte[] getCompactLen(int len){
	    byte[] buf = new byte[3];	    
	    int bytes = 0;
	    buf[bytes++] = (byte)(len & 0x7F);
	    if (len > 0x7F) {
	      buf[bytes-1] |= 0x80;
	      buf[bytes++] = (byte)(len >> 7 & 0x7F);
	      if (len > 0x3FFF) {
		buf[bytes-1] |= 0x80;
		buf[bytes++] = (byte)(len >> 14 & 0xFF);
	      }
	    }
	    byte[] salida = new byte[bytes];
	    for (int p = 0; p<bytes;p++){
	    	salida[p]=buf[p];
	    }
	    return salida;
	}	
}