package gnu.rfb.server;


public class DesCipher
{

    public DesCipher(byte abyte0[])
    {
        encryptKeys = new int[32];
        decryptKeys = new int[32];
        tempInts = new int[2];
        setKey(abyte0);
    }

    public void setKey(byte abyte0[])
    {
        deskey(abyte0, true, encryptKeys);
        deskey(abyte0, false, decryptKeys);
    }

    private void deskey(byte abyte0[], boolean flag, int ai[])
    {
        int ai1[] = new int[56];
        int ai2[] = new int[56];
        int ai3[] = new int[32];
        for(int j = 0; j < 56; j++)
        {
            byte byte0 = pc1[j];
            int l1 = byte0 & 7;
            if(byte0 >>> 3 < abyte0.length)
                ai1[j] = (abyte0[byte0 >>> 3] & bytebit[l1]) == 0 ? 0 : 1;
        }

        for(int i = 0; i < 16; i++)
        {
            int i2;
            if(flag)
                i2 = i << 1;
            else
                i2 = 15 - i << 1;
            int j2 = i2 + 1;
            ai3[i2] = ai3[j2] = 0;
            for(int k = 0; k < 28; k++)
            {
                int j1 = k + totrot[i];
                if(j1 < 28)
                    ai2[k] = ai1[j1];
                else
                    ai2[k] = ai1[j1 - 28];
            }

            for(int l = 28; l < 56; l++)
            {
                int k1 = l + totrot[i];
                if(k1 < 56)
                    ai2[l] = ai1[k1];
                else
                    ai2[l] = ai1[k1 - 28];
            }

            for(int i1 = 0; i1 < 24; i1++)
            {
                if(ai2[pc2[i1]] != 0)
                    ai3[i2] |= bigbyte[i1];
                if(ai2[pc2[i1 + 24]] != 0)
                    ai3[j2] |= bigbyte[i1];
            }

        }

        cookey(ai3, ai);
    }

    private void cookey(int ai[], int ai1[])
    {
        int i1 = 0;
        int k = 0;
        int l = 0;
        for(; i1 < 16; i1++)
        {
            int i = ai[k++];
            int j = ai[k++];
            ai1[l] = (i & 0xfc0000) << 6;
            ai1[l] |= (i & 0xfc0) << 10;
            ai1[l] |= (j & 0xfc0000) >>> 10;
            ai1[l] |= (j & 0xfc0) >>> 6;
            l++;
            ai1[l] = (i & 0x3f000) << 12;
            ai1[l] |= (i & 0x3f) << 16;
            ai1[l] |= (j & 0x3f000) >>> 4;
            ai1[l] |= j & 0x3f;
            l++;
        }

    }

    public void encrypt(byte abyte0[], int i, byte abyte1[], int j)
    {
        squashBytesToInts(abyte0, i, tempInts, 0, 2);
        des(tempInts, tempInts, encryptKeys);
        spreadIntsToBytes(tempInts, 0, abyte1, j, 2);
    }

    public void decrypt(byte abyte0[], int i, byte abyte1[], int j)
    {
        squashBytesToInts(abyte0, i, tempInts, 0, 2);
        des(tempInts, tempInts, decryptKeys);
        spreadIntsToBytes(tempInts, 0, abyte1, j, 2);
    }

    private void des(int ai[], int ai1[], int ai2[])
    {
        int j1 = 0;
        int l = ai[0];
        int k = ai[1];
        int j = (l >>> 4 ^ k) & 0xf0f0f0f;
        k ^= j;
        l ^= j << 4;
        j = (l >>> 16 ^ k) & 0xffff;
        k ^= j;
        l ^= j << 16;
        j = (k >>> 2 ^ l) & 0x33333333;
        l ^= j;
        k ^= j << 2;
        j = (k >>> 8 ^ l) & 0xff00ff;
        l ^= j;
        k ^= j << 8;
        k = k << 1 | k >>> 31 & 1;
        j = (l ^ k) & 0xaaaaaaaa;
        l ^= j;
        k ^= j;
        l = l << 1 | l >>> 31 & 1;
        for(int i1 = 0; i1 < 8; i1++)
        {
            j = k << 28 | k >>> 4;
            j ^= ai2[j1++];
            int i = SP7[j & 0x3f];
            i |= SP5[j >>> 8 & 0x3f];
            i |= SP3[j >>> 16 & 0x3f];
            i |= SP1[j >>> 24 & 0x3f];
            j = k ^ ai2[j1++];
            i |= SP8[j & 0x3f];
            i |= SP6[j >>> 8 & 0x3f];
            i |= SP4[j >>> 16 & 0x3f];
            i |= SP2[j >>> 24 & 0x3f];
            l ^= i;
            j = l << 28 | l >>> 4;
            j ^= ai2[j1++];
            i = SP7[j & 0x3f];
            i |= SP5[j >>> 8 & 0x3f];
            i |= SP3[j >>> 16 & 0x3f];
            i |= SP1[j >>> 24 & 0x3f];
            j = l ^ ai2[j1++];
            i |= SP8[j & 0x3f];
            i |= SP6[j >>> 8 & 0x3f];
            i |= SP4[j >>> 16 & 0x3f];
            i |= SP2[j >>> 24 & 0x3f];
            k ^= i;
        }

        k = k << 31 | k >>> 1;
        j = (l ^ k) & 0xaaaaaaaa;
        l ^= j;
        k ^= j;
        l = l << 31 | l >>> 1;
        j = (l >>> 8 ^ k) & 0xff00ff;
        k ^= j;
        l ^= j << 8;
        j = (l >>> 2 ^ k) & 0x33333333;
        k ^= j;
        l ^= j << 2;
        j = (k >>> 16 ^ l) & 0xffff;
        l ^= j;
        k ^= j << 16;
        j = (k >>> 4 ^ l) & 0xf0f0f0f;
        l ^= j;
        k ^= j << 4;
        ai1[0] = k;
        ai1[1] = l;
    }

    public static void squashBytesToInts(byte abyte0[], int i, int ai[], int j, int k)
    {
        for(int l = 0; l < k; l++)
            ai[j + l] = (abyte0[i + l * 4] & 0xff) << 24 | (abyte0[i + l * 4 + 1] & 0xff) << 16 | (abyte0[i + l * 4 + 2] & 0xff) << 8 | abyte0[i + l * 4 + 3] & 0xff;

    }

    public static void spreadIntsToBytes(int ai[], int i, byte abyte0[], int j, int k)
    {
        for(int l = 0; l < k; l++)
        {
            abyte0[j + l * 4] = (byte)(ai[i + l] >>> 24);
            abyte0[j + l * 4 + 1] = (byte)(ai[i + l] >>> 16);
            abyte0[j + l * 4 + 2] = (byte)(ai[i + l] >>> 8);
            abyte0[j + l * 4 + 3] = (byte)ai[i + l];
        }

    }

    private int encryptKeys[];
    private int decryptKeys[];
    private int tempInts[];
    private static byte bytebit[] = {
        1, 2, 4, 8, 16, 32, 64, -128
    };
    private static int bigbyte[] = {
        0x800000, 0x400000, 0x200000, 0x100000, 0x80000, 0x40000, 0x20000, 0x10000, 32768, 16384, 
        8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 
        8, 4, 2, 1
    };
    private static byte pc1[] = {
        56, 48, 40, 32, 24, 16, 8, 0, 57, 49, 
        41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 
        26, 18, 10, 2, 59, 51, 43, 35, 62, 54, 
        46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 
        29, 21, 13, 5, 60, 52, 44, 36, 28, 20, 
        12, 4, 27, 19, 11, 3
    };
    private static int totrot[] = {
        1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 
        19, 21, 23, 25, 27, 28
    };
    private static byte pc2[] = {
        13, 16, 10, 23, 0, 4, 2, 27, 14, 5, 
        20, 9, 22, 18, 11, 3, 25, 7, 15, 6, 
        26, 19, 12, 1, 40, 51, 30, 36, 46, 54, 
        29, 39, 50, 44, 32, 47, 43, 48, 38, 55, 
        33, 52, 45, 41, 49, 35, 28, 31
    };
    private static int SP1[] = {
        0x1010400, 0, 0x10000, 0x1010404, 0x1010004, 0x10404, 4, 0x10000, 1024, 0x1010400, 
        0x1010404, 1024, 0x1000404, 0x1010004, 0x1000000, 4, 1028, 0x1000400, 0x1000400, 0x10400, 
        0x10400, 0x1010000, 0x1010000, 0x1000404, 0x10004, 0x1000004, 0x1000004, 0x10004, 0, 1028, 
        0x10404, 0x1000000, 0x10000, 0x1010404, 4, 0x1010000, 0x1010400, 0x1000000, 0x1000000, 1024, 
        0x1010004, 0x10000, 0x10400, 0x1000004, 1024, 4, 0x1000404, 0x10404, 0x1010404, 0x10004, 
        0x1010000, 0x1000404, 0x1000004, 1028, 0x10404, 0x1010400, 1028, 0x1000400, 0x1000400, 0, 
        0x10004, 0x10400, 0, 0x1010004
    };
    private static int SP2[] = {
        0x80108020, 0x80008000, 32768, 0x108020, 0x100000, 32, 0x80100020, 0x80008020, 0x80000020, 0x80108020, 
        0x80108000, 0x80000000, 0x80008000, 0x100000, 32, 0x80100020, 0x108000, 0x100020, 0x80008020, 0, 
        0x80000000, 32768, 0x108020, 0x80100000, 0x100020, 0x80000020, 0, 0x108000, 32800, 0x80108000, 
        0x80100000, 32800, 0, 0x108020, 0x80100020, 0x100000, 0x80008020, 0x80100000, 0x80108000, 32768, 
        0x80100000, 0x80008000, 32, 0x80108020, 0x108020, 32, 32768, 0x80000000, 32800, 0x80108000, 
        0x100000, 0x80000020, 0x100020, 0x80008020, 0x80000020, 0x100020, 0x108000, 0, 0x80008000, 32800, 
        0x80000000, 0x80100020, 0x80108020, 0x108000
    };
    private static int SP3[] = {
        520, 0x8020200, 0, 0x8020008, 0x8000200, 0, 0x20208, 0x8000200, 0x20008, 0x8000008, 
        0x8000008, 0x20000, 0x8020208, 0x20008, 0x8020000, 520, 0x8000000, 8, 0x8020200, 512, 
        0x20200, 0x8020000, 0x8020008, 0x20208, 0x8000208, 0x20200, 0x20000, 0x8000208, 8, 0x8020208, 
        512, 0x8000000, 0x8020200, 0x8000000, 0x20008, 520, 0x20000, 0x8020200, 0x8000200, 0, 
        512, 0x20008, 0x8020208, 0x8000200, 0x8000008, 512, 0, 0x8020008, 0x8000208, 0x20000, 
        0x8000000, 0x8020208, 8, 0x20208, 0x20200, 0x8000008, 0x8020000, 0x8000208, 520, 0x8020000, 
        0x20208, 8, 0x8020008, 0x20200
    };
    private static int SP4[] = {
        0x802001, 8321, 8321, 128, 0x802080, 0x800081, 0x800001, 8193, 0, 0x802000, 
        0x802000, 0x802081, 129, 0, 0x800080, 0x800001, 1, 8192, 0x800000, 0x802001, 
        128, 0x800000, 8193, 8320, 0x800081, 1, 8320, 0x800080, 8192, 0x802080, 
        0x802081, 129, 0x800080, 0x800001, 0x802000, 0x802081, 129, 0, 0, 0x802000, 
        8320, 0x800080, 0x800081, 1, 0x802001, 8321, 8321, 128, 0x802081, 129, 
        1, 8192, 0x800001, 8193, 0x802080, 0x800081, 8193, 8320, 0x800000, 0x802001, 
        128, 0x800000, 8192, 0x802080
    };
    private static int SP5[] = {
        256, 0x2080100, 0x2080000, 0x42000100, 0x80000, 256, 0x40000000, 0x2080000, 0x40080100, 0x80000, 
        0x2000100, 0x40080100, 0x42000100, 0x42080000, 0x80100, 0x40000000, 0x2000000, 0x40080000, 0x40080000, 0, 
        0x40000100, 0x42080100, 0x42080100, 0x2000100, 0x42080000, 0x40000100, 0, 0x42000000, 0x2080100, 0x2000000, 
        0x42000000, 0x80100, 0x80000, 0x42000100, 256, 0x2000000, 0x40000000, 0x2080000, 0x42000100, 0x40080100, 
        0x2000100, 0x40000000, 0x42080000, 0x2080100, 0x40080100, 256, 0x2000000, 0x42080000, 0x42080100, 0x80100, 
        0x42000000, 0x42080100, 0x2080000, 0, 0x40080000, 0x42000000, 0x80100, 0x2000100, 0x40000100, 0x80000, 
        0, 0x40080000, 0x2080100, 0x40000100
    };
    private static int SP6[] = {
        0x20000010, 0x20400000, 16384, 0x20404010, 0x20400000, 16, 0x20404010, 0x400000, 0x20004000, 0x404010, 
        0x400000, 0x20000010, 0x400010, 0x20004000, 0x20000000, 16400, 0, 0x400010, 0x20004010, 16384, 
        0x404000, 0x20004010, 16, 0x20400010, 0x20400010, 0, 0x404010, 0x20404000, 16400, 0x404000, 
        0x20404000, 0x20000000, 0x20004000, 16, 0x20400010, 0x404000, 0x20404010, 0x400000, 16400, 0x20000010, 
        0x400000, 0x20004000, 0x20000000, 16400, 0x20000010, 0x20404010, 0x404000, 0x20400000, 0x404010, 0x20404000, 
        0, 0x20400010, 16, 16384, 0x20400000, 0x404010, 16384, 0x400010, 0x20004010, 0, 
        0x20404000, 0x20000000, 0x400010, 0x20004010
    };
    private static int SP7[] = {
        0x200000, 0x4200002, 0x4000802, 0, 2048, 0x4000802, 0x200802, 0x4200800, 0x4200802, 0x200000, 
        0, 0x4000002, 2, 0x4000000, 0x4200002, 2050, 0x4000800, 0x200802, 0x200002, 0x4000800, 
        0x4000002, 0x4200000, 0x4200800, 0x200002, 0x4200000, 2048, 2050, 0x4200802, 0x200800, 2, 
        0x4000000, 0x200800, 0x4000000, 0x200800, 0x200000, 0x4000802, 0x4000802, 0x4200002, 0x4200002, 2, 
        0x200002, 0x4000000, 0x4000800, 0x200000, 0x4200800, 2050, 0x200802, 0x4200800, 2050, 0x4000002, 
        0x4200802, 0x4200000, 0x200800, 0, 2, 0x4200802, 0, 0x200802, 0x4200000, 2048, 
        0x4000002, 0x4000800, 2048, 0x200002
    };
    private static int SP8[] = {
        0x10001040, 4096, 0x40000, 0x10041040, 0x10000000, 0x10001040, 64, 0x10000000, 0x40040, 0x10040000, 
        0x10041040, 0x41000, 0x10041000, 0x41040, 4096, 64, 0x10040000, 0x10000040, 0x10001000, 4160, 
        0x41000, 0x40040, 0x10040040, 0x10041000, 4160, 0, 0, 0x10040040, 0x10000040, 0x10001000, 
        0x41040, 0x40000, 0x41040, 0x40000, 0x10041000, 4096, 64, 0x10040040, 4096, 0x41040, 
        0x10001000, 64, 0x10000040, 0x10040000, 0x10040040, 0x10000000, 0x40000, 0x10001040, 0, 0x10041040, 
        0x40040, 0x10000040, 0x10040000, 0x10001000, 0x10001040, 0, 0x10041040, 0x41000, 0x41000, 4160, 
        4160, 0x40040, 0x10000000, 0x10041000
    };

}