package gnu.rfb.server;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class RFBClients
{

    public RFBClients()
    {
        clients = new Hashtable<Object, Hashtable<Object, Object>>();
    }

    public boolean isEmpty()
    {
        return clients.isEmpty();
    }

    public void addClient(RFBClient rfbclient)
    {
        clients.put(rfbclient, new Hashtable<Object, Object>());
    }

    public void removeClient(RFBClient rfbclient)
    {
        clients.remove(rfbclient);
    }

    public void closeAll()
    {
        for(Enumeration enumeration = elements(); enumeration.hasMoreElements();)
        {
            RFBClient rfbclient = (RFBClient)enumeration.nextElement();
            try
            {
                rfbclient.close();
            }
            catch(IOException ioexception) { }
        }

        clients.clear();
    }

    public Enumeration elements()
    {
        return clients.keys();
    }

    public void setProperty(RFBClient rfbclient, String s, Object obj)
    {
        Hashtable<Object, Object> hashtable2 = (Hashtable <Object, Object>) clients.get(rfbclient);
        if(hashtable2 == null)
        {
            return;
        } else
        {
            hashtable2.put(s, obj);
            return;
        }
    }

    public Object getProperty(RFBClient rfbclient, String s)
    {
        Hashtable hashtable = (Hashtable)clients.get(rfbclient);
        if(hashtable == null)
            return null;
        else
            return hashtable.get(s);
    }

    Hashtable<Object, Hashtable<Object, Object>> clients;
}