package gnu.rfb.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.*;
import java.util.ArrayList;
import java.util.Iterator;

public class RFBHost
    implements Runnable
{

    public RFBHost(int i, String s, Class<?> class1, RFBAuthenticator rfbauthenticator)
        throws NoSuchMethodException
    {
        sharedServer = null;
        servers = new ArrayList();
        constructor = class1.getDeclaredConstructor(new Class[] {
            Integer.TYPE, java.lang.String.class
        });
        if(!(gnu.rfb.server.RFBServer.class).isAssignableFrom(class1))
        {
            throw new NoSuchMethodException("Class does not support RFBServer interface");
        } else
        {
            display = i;
            displayName = s;
            //authenticator = rfbauthenticator;
            (new Thread(this)).start();
            return;
        }
    }

    public synchronized void setSharedServer(RFBServer rfbserver)
    {
        sharedServer = rfbserver;
    }

    public synchronized RFBServer getSharedServer()
    {
        return sharedServer;
    }

    public void run()
    {
        isRunning = true;
        threadFinished = false;
        try
        {
            serverSocket = new ServerSocket(5900 + display);
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            close();
            return;
        }
        try
        {
            setSharedServer((RFBServer)constructor.newInstance(new Object[] {
                new Integer(display), displayName
            }));
            while(isRunning)
            {
                /*Socket socket = serverSocket.accept();
                if(servers.size() == 0)
                {
                    InetAddress inetaddress = socket.getInetAddress();
                    VLogger.getLogger().log("MSG7", inetaddress.getHostAddress() + " - " + inetaddress.getCanonicalHostName());
                    RFBSocket rfbsocket = new RFBSocket(socket, getSharedServer(), this, authenticator);
                    servers.add(rfbsocket);
                } else
                {
                    try
                    {
                        socket.close();
                    }
                    catch(Exception exception2) { }
                }*/
            }
        }
        catch(Exception exception1)
        {
        }
        finally
        {
            threadFinished = true;
            close();
        }
    }

    public void close(RFBSocket rfbsocket)
    {
        try
        {
            System.out.println("Close:" + rfbsocket);
            servers.remove(rfbsocket);
            System.out.println("Removed?:" + servers.size());
        }
        catch(Exception exception) { }
    }

    public void close(){
        try{
            serverSocket.close();
            serverSocket=null;
            isRunning = false;
            // Block until the thread has exited gracefully
            while(threadFinished == false){
                try{
                    Thread.sleep(20);
                }
                catch(InterruptedException x){
                }
            }

            // now go through all of there servers that were spawned
            Iterator iter = servers.iterator();
            while(iter.hasNext()){
                ((RFBSocket)iter.next()).close();
            }
        }
        catch(IOException e){
        }
        finally{
            serverSocket=null;
        }
    }
    public String getDisplayName()
    {
        return displayName;
    }

    private int display;
    private String displayName;
    //private RFBAuthenticator authenticator;
    private Constructor constructor;
    private RFBServer sharedServer;
    private boolean isRunning;
    private boolean threadFinished;
    private ServerSocket serverSocket;
    private ArrayList servers;
}