package gnu.rfb.server;

import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import java.io.IOException;

public interface RFBServer
{

    public abstract void close();

    public abstract void addClient(RFBClient rfbclient);

    public abstract void removeClient(RFBClient rfbclient);

    public abstract String getDesktopName(RFBClient rfbclient);

    public abstract int getFrameBufferWidth(RFBClient rfbclient);

    public abstract int getFrameBufferHeight(RFBClient rfbclient);

    public abstract PixelFormat getPreferredPixelFormat(RFBClient rfbclient);

    public abstract boolean allowShared();

    public abstract void setClientProtocolVersionMsg(RFBClient rfbclient, String s)
        throws IOException;

    public abstract void setShared(RFBClient rfbclient, boolean flag)
        throws IOException;

    public abstract void setPixelFormat(RFBClient rfbclient, PixelFormat pixelformat)
        throws IOException;

    public abstract void setEncodings(RFBClient rfbclient, int ai[])
        throws IOException;

    public abstract void fixColourMapEntries(RFBClient rfbclient, int i, Colour acolour[])
        throws IOException;

    public abstract void frameBufferUpdateRequest(RFBClient rfbclient, boolean flag, int i, int j, int k, int l)
        throws IOException;

    public abstract void keyEvent(RFBClient rfbclient, boolean flag, int i)
        throws IOException;

    public abstract void pointerEvent(RFBClient rfbclient, int i, int j, int k)
        throws IOException;

    public abstract void clientCutText(RFBClient rfbclient, String s)
        throws IOException;
}