package gnu.rfb.server;

import com.appletvnc.server.VNCHost;

import gnu.rfb.*;
import java.io.*;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;

import org.http.client.HTTPTSocket;

public class RFBSocket
    implements RFBClient, Runnable
{
    private class UpdateRequest
    {

        public boolean equals(Object obj)
        {
            if(obj instanceof UpdateRequest)
            {
                UpdateRequest updaterequest = (UpdateRequest)obj;
                return x == updaterequest.x && y == updaterequest.y && w == updaterequest.w && h == updaterequest.h;
            } else
            {
                return false;
            }
        }

        boolean incremental;
        int x;
        int y;
        int w;
        int h;

        public UpdateRequest(boolean flag, int i, int j, int k, int l)
        {
            incremental = flag;
            x = i;
            y = j;
            w = k;
            h = l;
        }
    }


    public RFBSocket(HTTPTSocket socket1, RFBServer rfbserver, VNCHost vnchost, RFBAuthenticator rfbauthenticator)
        throws IOException
    {
        server = null;
        pixelFormat = null;
        protocolVersionMsg = "";
        shared = true;
        encodings = new int[0];
        preferredEncoding = 7;
        isRunning = false;
        threadFinished = false;
        updateQueue = new Vector<Object>();
        updateAvailable = true;
        tunnel = socket1;
        server = rfbserver;
        host = vnchost;
        authenticator = rfbauthenticator;
        input = new DataInputStream(new BufferedInputStream(socket1.getInputStream()));
        output = new DataOutputStream(new BufferedOutputStream(socket1.getOutputStream(), 16384));
        (new Thread(this)).start();
    }
    
    public RFBSocket(Socket socket1, RFBServer rfbserver, VNCHost vnchost, RFBAuthenticator rfbauthenticator)
    throws IOException
{
    server = null;
    pixelFormat = null;
    protocolVersionMsg = "";
    shared = true;
    encodings = new int[0];
    preferredEncoding = 7;
    isRunning = false;
    threadFinished = false;
    updateQueue = new Vector<Object>();
    updateAvailable = true;
    socket = socket1;
    server = rfbserver;
    host = vnchost;
    authenticator = rfbauthenticator;
    input = new DataInputStream(new BufferedInputStream(socket1.getInputStream()));
    output = new DataOutputStream(new BufferedOutputStream(socket1.getOutputStream(), 16384));
    (new Thread(this)).start();
}

    public RFBSocket(HTTPTSocket socket1, RFBServer rfbserver, VNCHost vnchost, RFBAuthenticator rfbauthenticator, boolean flag)
        throws IOException
    {
        server = null;
        pixelFormat = null;
        protocolVersionMsg = "";
        shared = true;
        encodings = new int[0];
        preferredEncoding = 7;
        isRunning = false;
        threadFinished = false;
        updateQueue = new Vector<Object>();
        updateAvailable = true;
        tunnel = socket1;
        server = rfbserver;
        host = vnchost;
        authenticator = rfbauthenticator;
        input = new DataInputStream(new BufferedInputStream(socket1.getInputStream()));
        output = new DataOutputStream(new BufferedOutputStream(socket1.getOutputStream(), 16384));
        if(flag)
            run();
        else
            (new Thread(this)).start();
    }
    
    public RFBSocket(Socket socket1, RFBServer rfbserver, VNCHost vnchost, RFBAuthenticator rfbauthenticator, boolean flag)
    throws IOException
    {
    server = null;
    pixelFormat = null;
    protocolVersionMsg = "";
    shared = true;
    encodings = new int[0];
    preferredEncoding = 7;
    isRunning = false;
    threadFinished = false;
    updateQueue = new Vector<Object>();
    updateAvailable = true;
    socket = socket1;
    server = rfbserver;
    host = vnchost;
    authenticator = rfbauthenticator;
    input = new DataInputStream(new BufferedInputStream(socket1.getInputStream()));
    output = new DataOutputStream(new BufferedOutputStream(socket1.getOutputStream(), 16384));
    if(flag)
        run();
    else
        (new Thread(this)).start();
}

    /**
     * new constructor by Marcus Wolschon
     */
    public RFBSocket( HTTPTSocket socket, RFBServer server, RFBHost host, RFBAuthenticator authenticator ) throws IOException {
        this.tunnel = socket;
        this.server = server;
        this.host2 = host;
        this.authenticator = authenticator;
        // Streams
        input = new DataInputStream( new BufferedInputStream( socket.getInputStream() ) );
        output = new DataOutputStream( new BufferedOutputStream( socket.getOutputStream(), 16384 ) );

        // Start socket listener thread
        new Thread( this ).start();
    }
    
    public RFBSocket( Socket socket, RFBServer server, RFBHost host, RFBAuthenticator authenticator ) throws IOException {
        this.socket = socket;
        this.server = server;
        this.host2 = host;
        this.authenticator = authenticator;
        // Streams
        input = new DataInputStream( new BufferedInputStream( socket.getInputStream() ) );
        output = new DataOutputStream( new BufferedOutputStream( socket.getOutputStream(), 16384 ) );

        // Start socket listener thread
        new Thread( this ).start();
    }

    /**
     * new constructor by Marcus Wolschon
     */
    public RFBSocket( HTTPTSocket socket, RFBServer server, RFBHost host, RFBAuthenticator authenticator, boolean syncronous ) throws IOException {
        this.tunnel = socket;
        this.server = server;
        this.host2 = host;
        this.authenticator = authenticator;

        // Streams
        input = new DataInputStream( new BufferedInputStream( socket.getInputStream() ) );
        output = new DataOutputStream( new BufferedOutputStream( socket.getOutputStream(), 16384 ) );

        // Start socket listener thread
        if(syncronous) {
            run();
        }
        else {
            new Thread( this ).start();
        }
    }
    
    public RFBSocket( Socket socket, RFBServer server, RFBHost host, RFBAuthenticator authenticator, boolean syncronous ) throws IOException {
        this.socket = socket;
        this.server = server;
        this.host2 = host;
        this.authenticator = authenticator;

        // Streams
        input = new DataInputStream( new BufferedInputStream( socket.getInputStream() ) );
        output = new DataOutputStream( new BufferedOutputStream( socket.getOutputStream(), 16384 ) );

        // Start socket listener thread
        if(syncronous) {
            run();
        }
        else {
            new Thread( this ).start();
        }
    }

    public synchronized PixelFormat getPixelFormat()
    {
        return pixelFormat;
    }

    public synchronized String getProtocolVersionMsg()
    {
        return protocolVersionMsg;
    }

    public synchronized boolean getShared()
    {
        return shared;
    }

    public synchronized int getPreferredEncoding()
    {
        return preferredEncoding;
    }

    public synchronized void setPreferredEncoding(int i)
    {
        if(encodings.length > 0)
        {
            for(int j = 0; j < encodings.length; j++)
                if(i == encodings[j])
                {
                    preferredEncoding = i;
                    return;
                }

        } else
        {
            preferredEncoding = i;
        }
    }

    public synchronized int[] getEncodings()
    {
        return encodings;
    }

    public synchronized void writeFrameBufferUpdate(Rect arect[])
        throws IOException
    {
        writeServerMessageType(0);
        output.writeByte(0);
        int i = 0;
        for(int j = 0; j < arect.length; j++)
            i += arect[j].count;

        output.writeShort(i);
        for(int k = 0; k < arect.length; k++)
            arect[k].writeData(output);

        output.flush();
    }

    public synchronized void writeSetColourMapEntries(int i, Colour acolour[])
        throws IOException
    {
        writeServerMessageType(1);
        output.writeByte(0);
        output.writeShort(i);
        output.writeShort(acolour.length);
        for(int j = 0; j < acolour.length; j++)
        {
            output.writeShort(acolour[j].r);
            output.writeShort(acolour[j].g);
            output.writeShort(acolour[j].b);
        }

        output.flush();
    }

    public synchronized void writeBell()
        throws IOException
    {
        writeServerMessageType(2);
    }

    public synchronized void writeServerCutText(String s)
        throws IOException
    {
        writeServerMessageType(3);
        output.writeByte(0);
        output.writeShort(0);
        output.writeInt(s.length());
        output.writeBytes(s);
        output.writeByte(0);
        output.flush();
    }

//  Operations

    public synchronized void close(){
        isRunning = false;
        // Block until the thread has exited gracefully
        while(threadFinished == false){
            try{
                Thread.sleep(20);
            }
            catch(InterruptedException x){
            }
        }
        try{
        	if (tunnel != null)
        		tunnel.close();
        	else if (socket != null)
        		socket.close();
        }
        catch(Exception e){
        }
        finally{
            tunnel=null;
            socket=null;
        }
    }

    public void run() {
        isRunning =true;
        try {
            //                 System.err.println("DEBUG[RFBSocket] run() calling writeProtocolVersionMsg()");
            // Handshaking
            writeProtocolVersionMsg();
            //                 System.err.println("DEBUG[RFBSocket] run() calling readProtocolVersionMsg()");
            readProtocolVersionMsg();
            //                 System.err.println("DEBUG[RFBSocket] run() calling writeAuthScheme()");
            //if(((DefaultRFBAuthenticator)authenticator).authenticate(input,output)==false){
            if(authenticator.authenticate(input,output, this)==false){
                System.out.println("Authentiation failed");
                return;
            }
            //                 System.err.println("DEBUG[RFBSocket] run() calling readClientInit()");
            readClientInit();
            //                 System.err.println("DEBUG[RFBSocket] run() calling initServer()");
            initServer();
            //                 System.err.println("DEBUG[RFBSocket] run() calling writeServerInit()");
            writeServerInit();
            //                 System.err.println("DEBUG[RFBSocket] run() message loop");

            // RFBClient message loop
            while( isRunning ) {
                if(getUpdateIsAvailable()){
                    // go ahead and send the updates
                    doFrameBufferUpdate();
                }
                if(input.available() == 0){
                    try{
                        Thread.sleep(10);
                    }
                    catch(InterruptedException x){
                    }
                }
                else{
                    switch( input.readUnsignedByte() ) {
                        case rfb.SetPixelFormat:
                            readSetPixelFormat();
                            break;
                        case rfb.FixColourMapEntries:
                            readFixColourMapEntries();
                            break;
                        case rfb.SetEncodings:
                            readSetEncodings();
                            break;
                        case rfb.FrameBufferUpdateRequest:
                            readFrameBufferUpdateRequest();
                            break;
                        case rfb.KeyEvent:
                            readKeyEvent();
                            break;
                        case rfb.PointerEvent:
                            readPointerEvent();
                            break;
                        case rfb.ClientCutText:
                            readClientCutText();
                            break;
                    }
                }
            }
        }
        catch( IOException x ) {
            System.out.println("Got an IOException, drop the client");
        }
        catch(Throwable t){
            t.printStackTrace();
        }
        
        threadFinished = true;

        if( server != null ){
            server.removeClient( this );
        }

        
        close();
    }

    private void initServer()
        throws IOException
    {
        if(shared) {
        	if (host != null)
        		server = host.getSharedServer();
        	else
        		server = host2.getSharedServer();
        }
        server.addClient(this);
        server.setClientProtocolVersionMsg(this, protocolVersionMsg);
        server.setShared(this, shared);
    }

    private synchronized void writeProtocolVersionMsg()
        throws IOException
    {
        output.writeBytes("RFB 003.003\n");
        output.flush();
    }

    private synchronized void readProtocolVersionMsg()
        throws IOException
    {
        byte abyte0[] = new byte[12];
        input.readFully(abyte0);
        protocolVersionMsg = new String(abyte0);
    }

    private synchronized void readClientInit()
        throws IOException
    {
        shared = input.readUnsignedByte() == 1;
    }

    private synchronized void writeServerInit()
        throws IOException
    {
        output.writeShort(server.getFrameBufferWidth(this));
        output.writeShort(server.getFrameBufferHeight(this));
        server.getPreferredPixelFormat(this).writeData(output);
        output.writeByte(0);
        output.writeByte(0);
        output.writeByte(0);
        String s = server.getDesktopName(this);
        output.writeInt(s.length());
        output.writeBytes(s);
        output.flush();
    }

    private synchronized void writeServerMessageType(int i)
        throws IOException
    {
        output.writeByte(i);
    }

    private synchronized void readSetPixelFormat()
        throws IOException
    {
        input.readUnsignedByte();
        input.readUnsignedShort();
        pixelFormat = new PixelFormat(input);
        input.readUnsignedByte();
        input.readUnsignedShort();
        server.setPixelFormat(this, pixelFormat);
    }

    private synchronized void readFixColourMapEntries()
        throws IOException
    {
        input.readUnsignedByte();
        int i = input.readUnsignedShort();
        int j = input.readUnsignedShort();
        Colour acolour[] = new Colour[j];
        for(int k = 0; k < j; k++)
            acolour[k].readData(input);

        server.fixColourMapEntries(this, i, acolour);
    }

    private synchronized void readSetEncodings()
        throws IOException
    {
        input.readUnsignedByte();
        int i = input.readUnsignedShort();
        encodings = new int[i];
        for(int j = 0; j < i; j++)
            encodings[j] = input.readInt();

        preferredEncoding = Rect.bestEncoding(encodings);
        server.setEncodings(this, encodings);
    }

    private synchronized void readFrameBufferUpdateRequest()
        throws IOException
    {
        boolean flag = input.readUnsignedByte() != 0;
        int i = input.readUnsignedShort();
        int j = input.readUnsignedShort();
        int k = input.readUnsignedShort();
        int l = input.readUnsignedShort();
        UpdateRequest updaterequest = new UpdateRequest(flag, i, j, k, l);
        synchronized(updateQueue)
        {
            int i1 = updateQueue.indexOf(updaterequest);
            if(i1 >= 0)
            {
                if(!updaterequest.incremental)
                    updateQueue.setElementAt(updaterequest, i1);
            } else
            {
                updateQueue.add(updaterequest);
            }
        }
    }

    private synchronized void doFrameBufferUpdate() throws IOException{
        Iterator iter = updateQueue.iterator();
        while(iter.hasNext()){
            UpdateRequest ur = (UpdateRequest)iter.next();
            iter.remove();
            // Delegate to server
            try {
                server.frameBufferUpdateRequest( this, ur.incremental, ur.x, ur.y, ur.w, ur.h );
            }
            catch(IOException e)  // some times we have w==h==0 and it would result in a blue screen on the official VNC client.
            {
                // if there is nothing to encode, encode the top left pixel instead
                if(e.getMessage().startsWith("rects.length == 0")){
                    server.frameBufferUpdateRequest( this, false, 0, 0, 1, 1 );
                }
                else{
                    // rethrow it
                    throw e;
                }
            }
            finally{
                setUpdateIsAvailable(false);
            }
        }
    }

    private synchronized void readKeyEvent()
        throws IOException
    {
        boolean flag = input.readUnsignedByte() == 1;
        input.readUnsignedShort();
        int i = input.readInt();
        server.keyEvent(this, flag, i);
    }

    private synchronized void readPointerEvent()
        throws IOException
    {
        int i = input.readUnsignedByte();
        int j = input.readUnsignedShort();
        int k = input.readUnsignedShort();
        server.pointerEvent(this, i, j, k);
    }

    private synchronized void readClientCutText()
        throws IOException
    {
        input.readUnsignedByte();
        input.readUnsignedShort();
        int i = input.readInt();
        byte abyte0[] = new byte[i];
        input.readFully(abyte0);
        String s = new String(abyte0);
        server.clientCutText(this, s);
    }

    public InetAddress getInetAddress()
    {
    	if (tunnel != null) 
    		return tunnel.getInetAddress();
    	else if (socket != null) 
    		return socket.getInetAddress();
    	else return null;
    }

    public String getName()
    {
    	if (host != null)
    		return host.getDisplayName();
    	else return host2.getDisplayName();
    }

    public void setUpdateIsAvailable(boolean flag)
    {
        updateAvailable = flag;
    }

    public boolean getUpdateIsAvailable()
    {
        return updateAvailable;
    }

    private HTTPTSocket tunnel;
    private Socket socket;
    private VNCHost host;
    private RFBHost host2;
    private RFBAuthenticator authenticator;
    private RFBServer server;
    private DataInputStream input;
    private DataOutputStream output;
    private PixelFormat pixelFormat;
    private String protocolVersionMsg;
    private boolean shared;
    private int encodings[];
    private int preferredEncoding;
    private boolean isRunning;
    private boolean threadFinished;
    private Vector<Object> updateQueue;
    private boolean updateAvailable;
}